/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client.screen;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mrcrayfish.catalogue.client.ScreenUtil;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueCheckBoxButton;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueIconButton;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2291;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_7225;
import net.minecraft.class_757;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CatalogueModListScreen
extends class_437 {
    private static final class_2960 CATALOGUE_ICON = new class_2960("catalogue", "icon.png");
    private static final Comparator<ModEntry> SORT = Comparator.comparing(o -> o.getInfo().getName());
    private static final class_2960 MISSING_BANNER = new class_2960("catalogue", "textures/gui/missing_banner.png");
    private static final Map<String, Pair<class_2960, Size2i>> ICON_CACHE = new HashMap<String, Pair<class_2960, Size2i>>();
    private static final Map<String, Pair<class_2960, Size2i>> BANNER_CACHE = new HashMap<String, Pair<class_2960, Size2i>>();
    private static final Map<String, class_1799> ITEM_CACHE = new HashMap<String, class_1799>();
    private static List<ModInfo> cachedInfo;
    private static Map<String, BiFunction<class_437, ModContainer, class_437>> providers;
    private static class_2960 cachedBackground;
    private final class_437 parentScreen;
    private class_342 searchTextField;
    private ModList modList;
    private ModInfo selectedModInfo;
    private class_4185 modFolderButton;
    private class_4185 configButton;
    private class_4185 websiteButton;
    private class_4185 issueButton;
    private class_4286 libraryButton;
    private StringList descriptionList;
    private int tooltipYOffset;
    private List<? extends class_5481> activeTooltip;

    public CatalogueModListScreen(class_437 parentScreen) {
        super(class_5244.field_39003);
        if (cachedInfo == null) {
            cachedInfo = FabricLoaderImpl.INSTANCE.getAllMods().stream().map(ModInfo::new).collect(Collectors.toList());
            cachedInfo.removeIf(info -> info.getId().equals("minecraft"));
            cachedInfo.add(ModInfo.MINECRAFT);
        }
        if (providers == null) {
            providers = CatalogueModListScreen.findConfigFactoryProviders();
        }
        this.parentScreen = parentScreen;
        ICON_CACHE.clear();
    }

    protected void method_25426() {
        super.method_25426();
        this.searchTextField = new class_342(this.field_22793, 11, 25, 148, 20, class_5244.field_39003);
        this.searchTextField.method_1863(s -> {
            this.updateSearchField((String)s);
            this.modList.filterAndUpdateList((String)s);
            this.updateSelectedModList();
        });
        this.method_25429((class_364)this.searchTextField);
        this.modList = new ModList();
        this.modList.method_25333(10);
        this.modList.method_31323(false);
        this.method_25429((class_364)this.modList);
        this.method_37063((class_364)new class_4185(10, this.modList.getBottom() + 8, 127, 20, class_5244.field_24339, onPress -> this.field_22787.method_1507(this.parentScreen)));
        this.modFolderButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(140, this.modList.getBottom() + 8, 0, 0, onPress -> class_156.method_668().method_672(FabricLoader.getInstance().getGameDir().resolve("mods").toFile())));
        int padding = 10;
        int contentLeft = this.modList.getRight() + 12 + padding;
        int contentWidth = this.field_22789 - contentLeft - padding;
        int buttonWidth = (contentWidth - padding) / 3;
        this.configButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(contentLeft, 105, 10, 0, buttonWidth, (class_2561)class_2561.method_43471((String)"catalogue.gui.config"), onPress -> {
            if (this.selectedModInfo != null) {
                CatalogueModListScreen.openConfigScreen(this.selectedModInfo, this);
            }
        }));
        this.configButton.field_22764 = false;
        this.websiteButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(contentLeft + buttonWidth + 5, 105, 20, 0, buttonWidth, (class_2561)class_2561.method_43470((String)"Website"), onPress -> this.selectedModInfo.getHomepageLink().ifPresent(this::openLink)));
        this.websiteButton.field_22764 = false;
        this.issueButton = (class_4185)this.method_37063((class_364)new CatalogueIconButton(contentLeft + buttonWidth + buttonWidth + 10, 105, 30, 0, buttonWidth, (class_2561)class_2561.method_43470((String)"Submit Bug"), onPress -> this.selectedModInfo.getIssueLink().ifPresent(this::openLink)));
        this.issueButton.field_22764 = false;
        this.descriptionList = new StringList(contentWidth, this.field_22790 - 135 - 55, contentLeft, 130);
        this.descriptionList.method_31323(false);
        this.descriptionList.method_31322(false);
        this.method_25429((class_364)this.descriptionList);
        this.libraryButton = (class_4286)this.method_37063((class_364)new CatalogueCheckBoxButton(this.modList.getRight() - 14, 7, button -> {
            this.modList.filterAndUpdateList(this.searchTextField.method_1882());
            this.updateSelectedModList();
        }));
        this.modList.filterAndUpdateList(this.searchTextField.method_1882());
        if (this.selectedModInfo != null) {
            this.setSelectedModInfo(this.selectedModInfo);
            this.updateSelectedModList();
            ModEntry entry = this.modList.getEntryFromInfo(this.selectedModInfo);
            if (entry != null) {
                this.modList.centerScrollOn(entry);
            }
        }
        this.updateSearchField(this.searchTextField.method_1882());
    }

    private void openLink(String url) {
        class_2583 style = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, url));
        this.method_25430(style);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.method_25420(poseStack);
        if (this.field_22787.field_1687 != null) {
            int originalWidth = this.field_22789;
            this.field_22789 = this.modList.getRight() + 11;
            this.method_25434(0);
            this.field_22789 = originalWidth;
        }
        this.drawModList(poseStack, mouseX, mouseY, partialTicks);
        this.drawModInfo(poseStack, mouseX, mouseY, partialTicks);
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        RenderSystem.setShaderTexture((int)0, (class_2960)CATALOGUE_ICON);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_437.method_25293((class_4587)poseStack, (int)10, (int)9, (int)10, (int)10, (float)0.0f, (float)0.0f, (int)160, (int)160, (int)160, (int)160);
        if (ScreenUtil.isMouseWithin(10, 9, 10, 10, mouseX, mouseY)) {
            this.setActiveTooltip((class_2561)class_2561.method_43471((String)"catalogue.gui.info"));
            this.tooltipYOffset = 10;
        }
        if (this.modFolderButton.method_25405((double)mouseX, (double)mouseY)) {
            this.setActiveTooltip((class_2561)class_2561.method_43471((String)"catalogue.gui.open_mods_folder"));
        }
        if (this.activeTooltip != null) {
            this.method_25417(poseStack, this.activeTooltip, mouseX, mouseY + this.tooltipYOffset);
            this.tooltipYOffset = 0;
        }
    }

    private void updateSelectedModList() {
        ModEntry selectedEntry = this.modList.getEntryFromInfo(this.selectedModInfo);
        if (selectedEntry != null) {
            this.modList.method_25313(selectedEntry);
        }
    }

    private void updateSearchField(String value) {
        if (value.isEmpty()) {
            this.searchTextField.method_1887(class_2561.method_43471((String)"catalogue.gui.search").method_10852((class_2561)class_2561.method_43470((String)"...")).getString());
        } else {
            Optional<ModInfo> optional = cachedInfo.stream().filter(info -> info.getName().toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(ModInfo::getName));
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get().getName();
                this.searchTextField.method_1887(displayName.substring(length));
            } else {
                this.searchTextField.method_1887("");
            }
        }
    }

    private void drawModList(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.modList.method_25394(poseStack, mouseX, mouseY, partialTicks);
        CatalogueModListScreen.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)class_2561.method_43471((String)"catalogue.gui.mod_list").method_27692(class_124.field_1067).method_27692(class_124.field_1068), (int)85, (int)10, (int)0xFFFFFF);
        this.searchTextField.method_25394(poseStack, mouseX, mouseY, partialTicks);
        if (ScreenUtil.isMouseWithin(this.modList.getRight() - 14, 7, 14, 14, mouseX, mouseY)) {
            this.setActiveTooltip((class_2561)class_2561.method_43471((String)"catalogue.gui.internal_libraries"));
            this.tooltipYOffset = 10;
        }
    }

    private void drawModInfo(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25301(poseStack, this.modList.getRight() + 11, -1, this.field_22790, -9408400);
        CatalogueModListScreen.method_25294((class_4587)poseStack, (int)(this.modList.getRight() + 12), (int)0, (int)this.field_22789, (int)this.field_22790, (int)0x66000000);
        this.descriptionList.method_25394(poseStack, mouseX, mouseY, partialTicks);
        int contentLeft = this.modList.getRight() + 12 + 10;
        int contentWidth = this.field_22789 - contentLeft - 10;
        if (this.selectedModInfo != null) {
            String authors;
            this.drawBackground(poseStack, this.field_22789 - contentLeft + 10, this.modList.getRight() + 12, 0);
            this.drawLogo(poseStack, contentWidth, contentLeft, 10, this.field_22789 - (this.modList.getRight() + 12 + 10) - 10, 50);
            poseStack.method_22903();
            poseStack.method_22904((double)contentLeft, 70.0, 0.0);
            poseStack.method_22905(2.0f, 2.0f, 2.0f);
            CatalogueModListScreen.method_25303((class_4587)poseStack, (class_327)this.field_22793, (String)this.selectedModInfo.getName(), (int)0, (int)0, (int)0xFFFFFF);
            poseStack.method_22909();
            class_5250 modId = class_2561.method_43470((String)("Mod ID: " + this.selectedModInfo.getId())).method_27692(class_124.field_1063);
            int modIdWidth = this.field_22793.method_27525((class_5348)modId);
            CatalogueModListScreen.method_27535((class_4587)poseStack, (class_327)this.field_22793, (class_2561)modId, (int)(contentLeft + contentWidth - modIdWidth), (int)92, (int)0xFFFFFF);
            this.drawStringWithLabel(poseStack, "catalogue.gui.version", this.selectedModInfo.getVersion(), contentLeft, 92, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
            int labelOffset = this.field_22790 - 20;
            String license = this.selectedModInfo.getLicense();
            this.drawStringWithLabel(poseStack, "catalogue.gui.licenses", license, contentLeft, labelOffset, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
            labelOffset -= 15;
            String credits = this.selectedModInfo.getContributors();
            if (!credits.isEmpty()) {
                this.drawStringWithLabel(poseStack, "catalogue.gui.contributors", credits, contentLeft, labelOffset, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
                labelOffset -= 15;
            }
            if (!(authors = this.selectedModInfo.getAuthors()).isEmpty()) {
                this.drawStringWithLabel(poseStack, "catalogue.gui.authors", authors, contentLeft, labelOffset, contentWidth, mouseX, mouseY, class_124.field_1080, class_124.field_1068);
            }
        } else {
            class_5250 message = class_2561.method_43471((String)"catalogue.gui.no_selection").method_27692(class_124.field_1080);
            CatalogueModListScreen.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)message, (int)(contentLeft + contentWidth / 2), (int)(this.field_22790 / 2 - 5), (int)0xFFFFFF);
        }
    }

    private void drawStringWithLabel(class_4587 poseStack, String format, String text, int x, int y, int maxWidth, int mouseX, int mouseY, class_124 labelColor, class_124 contentColor) {
        String formatted = class_2561.method_43469((String)format, (Object[])new Object[]{text}).getString();
        String label = formatted.substring(0, formatted.indexOf(":") + 1);
        Object content = formatted.substring(formatted.indexOf(":") + 1);
        if (this.field_22793.method_1727(formatted) > maxWidth) {
            content = this.field_22793.method_27523((String)content, maxWidth - this.field_22793.method_1727(label) - 7) + "...";
            class_5250 credits = class_2561.method_43470((String)label).method_27692(labelColor);
            credits.method_10852((class_2561)class_2561.method_43470((String)content).method_27692(contentColor));
            CatalogueModListScreen.method_27535((class_4587)poseStack, (class_327)this.field_22793, (class_2561)credits, (int)x, (int)y, (int)0xFFFFFF);
            if (ScreenUtil.isMouseWithin(x, y, maxWidth, 9, mouseX, mouseY)) {
                this.setActiveTooltip((class_2561)class_2561.method_43470((String)text));
            }
        } else {
            CatalogueModListScreen.method_27535((class_4587)poseStack, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)label).method_27692(labelColor).method_10852((class_2561)class_2561.method_43470((String)content).method_27692(contentColor)), (int)x, (int)y, (int)0xFFFFFF);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin(10, 9, 10, 10, (int)mouseX, (int)mouseY) && button == 0) {
            this.openLink("https://www.curseforge.com/minecraft/mc-mods/catalogue");
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void setActiveTooltip(class_2561 content) {
        this.activeTooltip = this.field_22793.method_1728((class_5348)content, Math.min(200, this.field_22789));
        this.tooltipYOffset = 0;
    }

    private void setSelectedModInfo(ModInfo info) {
        this.selectedModInfo = info;
        this.loadAndCacheBanner(info);
        this.loadAndCacheBackground(info);
        this.configButton.field_22764 = true;
        this.websiteButton.field_22764 = true;
        this.issueButton.field_22764 = true;
        this.configButton.field_22763 = info.getConfigFactory().isPresent() || providers.containsKey(info.getId());
        this.websiteButton.field_22763 = info.getHomepageLink().isPresent();
        this.issueButton.field_22763 = info.getIssueLink().isPresent();
        int contentLeft = this.modList.getRight() + 12 + 10;
        int contentWidth = this.field_22789 - contentLeft - 10;
        int labelCount = this.getLabelCount(info);
        this.descriptionList.method_25323(contentWidth, this.field_22790 - 135 - 10 - labelCount * 15, 130, this.field_22790 - 10 - labelCount * 15);
        this.descriptionList.method_25333(contentLeft);
        this.descriptionList.setTextFromInfo(info);
        this.descriptionList.method_25307(0.0);
    }

    private int getLabelCount(ModInfo info) {
        int count = 1;
        if (!info.getContributors().isEmpty()) {
            ++count;
        }
        if (!info.getAuthors().isEmpty()) {
            ++count;
        }
        return count;
    }

    private void drawBackground(class_4587 poseStack, int contentWidth, int x, int y) {
        if (this.selectedModInfo == null) {
            return;
        }
        if (cachedBackground == null) {
            return;
        }
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderTexture((int)0, (class_2960)cachedBackground);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        class_1159 matrix = poseStack.method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        builder.method_22918(matrix, (float)x, (float)y, (float)this.method_25305()).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 0.0f).method_1344();
        builder.method_22918(matrix, (float)x, (float)(y + 128), (float)this.method_25305()).method_22915(0.0f, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        builder.method_22918(matrix, (float)(x + contentWidth), (float)(y + 128), (float)this.method_25305()).method_22915(0.0f, 0.0f, 0.0f, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        builder.method_22918(matrix, (float)(x + contentWidth), (float)y, (float)this.method_25305()).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 0.0f).method_1344();
        class_286.method_43433((class_287.class_7433)builder.method_1326());
        RenderSystem.disableBlend();
    }

    private void drawLogo(class_4587 poseStack, int contentWidth, int x, int y, int maxWidth, int maxHeight) {
        if (this.selectedModInfo != null) {
            class_2960 logoResource = MISSING_BANNER;
            Size2i size = new Size2i(600, 120);
            Pair<class_2960, Size2i> bannerInfo = BANNER_CACHE.get(this.selectedModInfo.getId());
            if (bannerInfo != null && bannerInfo.getLeft() != null) {
                logoResource = (class_2960)bannerInfo.getLeft();
                size = (Size2i)bannerInfo.getRight();
            } else {
                Pair<class_2960, Size2i> iconInfo = ICON_CACHE.get(this.selectedModInfo.getId());
                if (iconInfo != null && iconInfo.getLeft() != null) {
                    logoResource = (class_2960)iconInfo.getLeft();
                    size = (Size2i)iconInfo.getRight();
                }
            }
            RenderSystem.setShader(class_757::method_34541);
            RenderSystem.setShaderTexture((int)0, (class_2960)logoResource);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            int width = size.width;
            int height = size.height;
            if (size.width > maxWidth) {
                width = maxWidth;
                height = width * size.height / size.width;
            }
            if (height > maxHeight) {
                height = maxHeight;
                width = height * size.width / size.height;
            }
            class_437.method_25293((class_4587)poseStack, (int)(x += (contentWidth - width) / 2), (int)(y += (maxHeight - height) / 2), (int)width, (int)height, (float)0.0f, (float)0.0f, (int)size.width, (int)size.height, (int)size.width, (int)size.height);
            RenderSystem.disableBlend();
        }
    }

    private void loadAndCacheIcon(ModInfo info) {
        if (ICON_CACHE.containsKey(info.getId())) {
            return;
        }
        ICON_CACHE.put(info.getId(), (Pair<class_2960, Size2i>)Pair.of(null, (Object)new Size2i(0, 0)));
        info.getImageIcon().ifPresent(path -> {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);
                 class_1011 icon = class_1011.method_4309((InputStream)is);){
                if (icon.method_4307() == icon.method_4323()) {
                    class_1060 textureManager = this.field_22787.method_1531();
                    class_2960 location = textureManager.method_4617("catalogueicon", this.createLogoTexture(icon, false));
                    ICON_CACHE.put(info.getId(), (Pair<class_2960, Size2i>)Pair.of((Object)location, (Object)new Size2i(icon.method_4307(), icon.method_4323())));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private void loadAndCacheBanner(ModInfo info) {
        if (BANNER_CACHE.containsKey(info.getId())) {
            return;
        }
        BANNER_CACHE.put(info.getId(), (Pair<class_2960, Size2i>)Pair.of(null, (Object)new Size2i(0, 0)));
        info.getImageBanner().ifPresent(path -> {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);
                 class_1011 icon = class_1011.method_4309((InputStream)is);){
                class_1060 textureManager = this.field_22787.method_1531();
                class_2960 location = textureManager.method_4617("cataloguebanner", this.createLogoTexture(icon, false));
                BANNER_CACHE.put(info.getId(), (Pair<class_2960, Size2i>)Pair.of((Object)location, (Object)new Size2i(icon.method_4307(), icon.method_4323())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private void loadAndCacheBackground(ModInfo info) {
        if (cachedBackground != null) {
            class_1060 textureManager = this.field_22787.method_1531();
            textureManager.method_4615(cachedBackground);
        }
        cachedBackground = null;
        info.getImageBackground().ifPresent(path -> {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);
                 class_1011 icon = class_1011.method_4309((InputStream)is);){
                class_2960 location;
                if (icon.method_4307() != 512 || icon.method_4323() != 256) {
                    return;
                }
                class_1060 textureManager = this.field_22787.method_1531();
                cachedBackground = location = textureManager.method_4617("cataloguebackground", this.createLogoTexture(icon, false));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private class_1043 createLogoTexture(final class_1011 image, final boolean smooth) {
        return new class_1043(image){

            public void method_4524() {
                this.method_23207();
                image.method_22619(0, 0, 0, 0, 0, image.method_4307(), image.method_4323(), smooth, false, false, false);
            }
        };
    }

    private static Method findConfigFactoryMethod(String className) {
        try {
            Class<?> configFactoryClass = Class.forName(className);
            Method createConfigScreenMethod = configFactoryClass.getDeclaredMethod("createConfigScreen", class_437.class, ModContainer.class);
            int mods = createConfigScreenMethod.getModifiers();
            if (!Modifier.isPublic(mods)) {
                throw new RuntimeException("createConfigScreen is not accessible for class: " + className);
            }
            if (!Modifier.isStatic(mods)) {
                throw new RuntimeException("createConfigScreen is not static for class: " + className);
            }
            return createConfigScreenMethod;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to locate config factory class: " + className);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static void openConfigScreen(ModInfo info, class_437 currentScreen) {
        class_437 configScreen;
        BiFunction<class_437, ModContainer, class_437> configFactory;
        Optional<Method> optional = info.getConfigFactory();
        if (optional.isPresent()) {
            try {
                Object object = optional.get().invoke(null, currentScreen, info.container);
                if (object instanceof class_437) {
                    class_437 configScreen2 = (class_437)object;
                    class_310.method_1551().method_1507(configScreen2);
                    return;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if ((configFactory = providers.get(info.getId())) != null && (configScreen = configFactory.apply(currentScreen, info.container)) != null) {
            class_310.method_1551().method_1507(configScreen);
        }
    }

    private static Map<String, BiFunction<class_437, ModContainer, class_437>> findConfigFactoryProviders() {
        HashMap providers = new HashMap();
        FabricLoader.getInstance().getAllMods().forEach(container -> {
            ModMetadata metadata = container.getMetadata();
            CustomValue value = metadata.getCustomValue("catalogue");
            if (value == null || value.getType() != CustomValue.CvType.OBJECT) {
                return;
            }
            CustomValue.CvObject catalogueObj = value.getAsObject();
            CustomValue configFactoryValue = catalogueObj.get("configFactory");
            if (configFactoryValue == null || configFactoryValue.getType() != CustomValue.CvType.STRING) {
                return;
            }
            String className = configFactoryValue.getAsString();
            Optional.ofNullable(CatalogueModListScreen.createConfigFactoryProvider(className)).ifPresent(map -> map.forEach(providers::putIfAbsent));
        });
        return ImmutableMap.copyOf(providers);
    }

    private static Map<String, BiFunction<class_437, ModContainer, class_437>> createConfigFactoryProvider(String className) {
        try {
            Class<?> configFactoryClass = Class.forName(className);
            Method createConfigProviderMethod = configFactoryClass.getDeclaredMethod("createConfigProvider", new Class[0]);
            int mods = createConfigProviderMethod.getModifiers();
            if (!Modifier.isPublic(mods)) {
                throw new RuntimeException("createConfigProvider is not accessible for class: " + className);
            }
            if (!Modifier.isStatic(mods)) {
                throw new RuntimeException("createConfigProvider is not static for class: " + className);
            }
            if (createConfigProviderMethod.getReturnType() != Map.class) {
                throw new RuntimeException("createConfigProvider must return a Map<String, BiFunction<Screen, ModContainer, Screen>>");
            }
            return (Map)createConfigProviderMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to locate config factory class: " + className);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static class ModInfo {
        private static final ModInfo MINECRAFT = new ModInfo();
        private final ModContainer container;
        private final String id;
        private final String name;
        private final String description;
        private final String version;
        private final String imageIcon;
        private final String imageBanner;
        private final String imageBackground;
        private final String itemIcon;
        private final String license;
        private final String authors;
        private final String contributors;
        private final String issueLink;
        private final String homepageLink;
        private final Method configFactory;
        private final Type type;

        private ModInfo() {
            ModContainer c = FabricLoader.getInstance().getModContainer("minecraft").orElse(null);
            Objects.requireNonNull(c);
            this.container = c;
            this.id = "minecraft";
            this.name = "Minecraft";
            this.description = "";
            this.version = c.getMetadata().getVersion().getFriendlyString();
            this.imageIcon = null;
            this.imageBanner = null;
            this.imageBackground = null;
            this.itemIcon = null;
            this.license = "All Rights Reserved";
            this.authors = "Mojang AB";
            this.contributors = "";
            this.issueLink = null;
            this.homepageLink = "https://minecraft.net/";
            this.configFactory = null;
            this.type = Type.LIBRARY;
        }

        public ModInfo(ModContainer container) {
            ModMetadata metadata = container.getMetadata();
            this.container = container;
            this.id = metadata.getId();
            this.name = metadata.getName();
            this.description = metadata.getDescription();
            this.version = metadata.getVersion().getFriendlyString();
            this.license = StringUtils.join((Iterable)metadata.getLicense(), (String)", ");
            this.authors = StringUtils.join((Iterable)metadata.getAuthors().stream().map(Person::getName).collect(Collectors.toList()), (String)", ");
            this.contributors = StringUtils.join((Iterable)metadata.getContributors().stream().map(Person::getName).collect(Collectors.toList()), (String)", ");
            this.issueLink = metadata.getContact().get("issues").orElse(null);
            this.homepageLink = metadata.getContact().get("homepage").orElse(null);
            this.type = Type.getType(container);
            String imageIcon = metadata.getIconPath(64).orElse(null);
            String imageBanner = null;
            String imageBackground = null;
            String itemIcon = null;
            Method configFactory = null;
            CustomValue value = metadata.getCustomValue("catalogue");
            if (value != null && value.getType() == CustomValue.CvType.OBJECT) {
                CustomValue configFactoryValue;
                CustomValue backgroundValue;
                CustomValue bannerValue;
                CustomValue.CvObject catalogueObj = value.getAsObject();
                CustomValue iconValue = catalogueObj.get("icon");
                if (iconValue != null && iconValue.getType() == CustomValue.CvType.OBJECT) {
                    CustomValue itemValue;
                    CustomValue.CvObject iconObj = iconValue.getAsObject();
                    CustomValue imageValue = iconObj.get("image");
                    if (imageValue != null && imageValue.getType() == CustomValue.CvType.STRING) {
                        imageIcon = imageValue.getAsString();
                    }
                    if ((itemValue = iconObj.get("item")) != null && itemValue.getType() == CustomValue.CvType.STRING) {
                        itemIcon = itemValue.getAsString();
                    }
                }
                if ((bannerValue = catalogueObj.get("banner")) != null && bannerValue.getType() == CustomValue.CvType.STRING) {
                    imageBanner = bannerValue.getAsString();
                }
                if ((backgroundValue = catalogueObj.get("background")) != null && backgroundValue.getType() == CustomValue.CvType.STRING) {
                    imageBackground = backgroundValue.getAsString();
                }
                if ((configFactoryValue = catalogueObj.get("configFactory")) != null && configFactoryValue.getType() == CustomValue.CvType.STRING) {
                    configFactory = CatalogueModListScreen.findConfigFactoryMethod(configFactoryValue.getAsString());
                }
            }
            this.imageIcon = imageIcon;
            this.itemIcon = itemIcon;
            this.imageBanner = imageBanner;
            this.imageBackground = imageBackground;
            this.configFactory = configFactory;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVersion() {
            return this.version;
        }

        public Optional<Path> getImageIcon() {
            return Optional.ofNullable(this.imageIcon).flatMap(arg_0 -> ((ModContainer)this.container).findPath(arg_0));
        }

        public Optional<Path> getImageBanner() {
            return Optional.ofNullable(this.imageBanner).flatMap(arg_0 -> ((ModContainer)this.container).findPath(arg_0));
        }

        public Optional<Path> getImageBackground() {
            return Optional.ofNullable(this.imageBackground).flatMap(arg_0 -> ((ModContainer)this.container).findPath(arg_0));
        }

        public Optional<String> getItemIcon() {
            return Optional.ofNullable(this.itemIcon);
        }

        public String getLicense() {
            return this.license;
        }

        public String getAuthors() {
            return this.authors;
        }

        public String getContributors() {
            return this.contributors;
        }

        public Optional<String> getIssueLink() {
            return Optional.ofNullable(this.issueLink);
        }

        public Optional<String> getHomepageLink() {
            return Optional.ofNullable(this.homepageLink);
        }

        public Optional<Method> getConfigFactory() {
            return Optional.ofNullable(this.configFactory);
        }

        public Type getType() {
            return this.type;
        }

        static enum Type {
            MOD(class_124.field_1070),
            LIBRARY(class_124.field_1063),
            GENERATED(class_124.field_1075);

            private final class_124 style;

            private Type(class_124 style) {
                this.style = style;
            }

            public class_124 getStyle() {
                return this.style;
            }

            static Type getType(ModContainer container) {
                CustomValue lifecycle = container.getMetadata().getCustomValue("fabric-api:module-lifecycle");
                if (lifecycle != null) {
                    return LIBRARY;
                }
                String modId = container.getMetadata().getId();
                if (modId.startsWith("fabric-") || modId.equals("minecraft") || modId.equals("java") || modId.equals("fabricloader")) {
                    return LIBRARY;
                }
                CustomValue generated = container.getMetadata().getCustomValue("fabric-loom:generated");
                if (generated != null && generated.getType() == CustomValue.CvType.BOOLEAN && generated.getAsBoolean()) {
                    return GENERATED;
                }
                return MOD;
            }
        }
    }

    private class ModList
    extends class_350<ModEntry> {
        public ModList() {
            super(CatalogueModListScreen.this.field_22787, 150, CatalogueModListScreen.this.field_22790, 46, CatalogueModListScreen.this.field_22790 - 35, 26);
        }

        public int getLeft() {
            return this.field_19088;
        }

        public int getRight() {
            return this.field_19087;
        }

        public int getTop() {
            return this.field_19085;
        }

        public int getBottom() {
            return this.field_19086;
        }

        public int getWidth() {
            return this.field_22742;
        }

        protected int method_25329() {
            return this.getLeft() + this.field_22742 - 6;
        }

        public int method_25342() {
            return this.getLeft();
        }

        public int method_25322() {
            return this.field_22742;
        }

        public void filterAndUpdateList(String text) {
            List entries = cachedInfo.stream().filter(info -> info.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))).filter(info -> info.getType() == ModInfo.Type.MOD || info.getId().equals("minecraft") || info.getId().equals("fabric-api") || CatalogueModListScreen.this.libraryButton.method_20372()).map(info -> new ModEntry((ModInfo)info, this)).sorted(SORT).collect(Collectors.toList());
            this.method_25314(entries);
            this.method_25307(0.0);
        }

        @Nullable
        public ModEntry getEntryFromInfo(ModInfo info) {
            return this.method_25396().stream().filter(entry -> entry.info == info).findFirst().orElse(null);
        }

        public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
            ScreenUtil.scissor(this.method_25342(), this.getTop(), this.getWidth(), this.getBottom() - this.getTop());
            super.method_25394(poseStack, mouseX, mouseY, partialTicks);
            RenderSystem.disableScissor();
        }

        public boolean method_25404(int key, int scanCode, int modifiers) {
            if (key == 257 && this.method_25334() != null) {
                CatalogueModListScreen.this.setSelectedModInfo(((ModEntry)this.method_25334()).info);
                class_1144 handler = class_310.method_1551().method_1483();
                handler.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                return true;
            }
            return super.method_25404(key, scanCode, modifiers);
        }

        public void method_37020(class_6382 p_169152_) {
        }

        public void centerScrollOn(ModEntry entry) {
            super.method_25324((class_350.class_351)entry);
        }
    }

    private class StringList
    extends class_350<StringEntry> {
        public StringList(int width, int height, int left, int top) {
            super(CatalogueModListScreen.this.field_22787, width, CatalogueModListScreen.this.field_22790, top, top + height, 10);
            this.method_25333(left);
        }

        public void setTextFromInfo(ModInfo info) {
            this.method_25339();
            CatalogueModListScreen.this.field_22793.method_27527().method_27498(info.getDescription().trim(), this.method_25322(), class_2583.field_24360).forEach(text -> this.method_25321(new StringEntry(text.getString().replace("\n", "").replace("\r", "").trim())));
        }

        public void setSelected(@Nullable StringEntry entry) {
        }

        protected int method_25329() {
            return this.getLeft() + this.field_22742 - 7;
        }

        public int method_25342() {
            return this.getLeft();
        }

        public int method_25322() {
            return this.field_22742 - 10;
        }

        public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
            ScreenUtil.scissor(this.method_25342(), this.getTop(), this.getWidth(), this.getBottom() - this.getTop());
            super.method_25394(poseStack, mouseX, mouseY, partialTicks);
            RenderSystem.disableScissor();
        }

        public void method_37020(class_6382 p_169152_) {
        }

        public int getLeft() {
            return this.field_19088;
        }

        public int getRight() {
            return this.field_19087;
        }

        public int getTop() {
            return this.field_19085;
        }

        public int getBottom() {
            return this.field_19086;
        }

        public int getWidth() {
            return this.field_22742;
        }
    }

    private class ModEntry
    extends class_350.class_351<ModEntry> {
        private final ModInfo info;
        private final ModList list;

        public ModEntry(ModInfo info, ModList list) {
            this.info = info;
            this.list = list;
        }

        public void method_25343(class_4587 poseStack, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            class_332.method_27535((class_4587)poseStack, (class_327)CatalogueModListScreen.this.field_22793, (class_2561)this.getFormattedModName(), (int)(left + 24), (int)(top + 2), (int)0xFFFFFF);
            class_332.method_27535((class_4587)poseStack, (class_327)CatalogueModListScreen.this.field_22793, (class_2561)class_2561.method_43470((String)this.info.getVersion().toString()).method_27692(class_124.field_1080), (int)(left + 24), (int)(top + 12), (int)0xFFFFFF);
            CatalogueModListScreen.this.loadAndCacheIcon(this.info);
            if (ICON_CACHE.containsKey(this.info.getId()) && ICON_CACHE.get(this.info.getId()).getLeft() != null) {
                class_2960 logoResource = class_1060.field_5285;
                Size2i size = new Size2i(16, 16);
                Pair<class_2960, Size2i> logoInfo = ICON_CACHE.get(this.info.getId());
                if (logoInfo != null && logoInfo.getLeft() != null) {
                    logoResource = (class_2960)logoInfo.getLeft();
                    size = (Size2i)logoInfo.getRight();
                }
                RenderSystem.setShader(class_757::method_34541);
                RenderSystem.setShaderTexture((int)0, (class_2960)logoResource);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                class_437.method_25293((class_4587)poseStack, (int)(left + 4), (int)(top + 2), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)size.width, (int)size.height, (int)size.width, (int)size.height);
                RenderSystem.disableBlend();
            } else {
                try {
                    CatalogueModListScreen.this.field_22787.method_1480().method_4010(this.getItemIcon(), left + 4, top + 2);
                }
                catch (Exception e) {
                    ITEM_CACHE.put(this.info.getId(), new class_1799((class_1935)class_1802.field_8270));
                }
            }
        }

        private class_1799 getItemIcon() {
            class_1799 item2;
            Optional<class_1799> optional;
            if (ITEM_CACHE.containsKey(this.info.getId())) {
                return ITEM_CACHE.get(this.info.getId());
            }
            ITEM_CACHE.put(this.info.getId(), new class_1799((class_1935)class_1802.field_8270));
            if (this.info.getId().equals("forge")) {
                class_1799 item3 = new class_1799((class_1935)class_1802.field_8782);
                ITEM_CACHE.put("forge", item3);
                return item3;
            }
            Optional<String> itemIcon = this.info.getItemIcon();
            if (itemIcon.isPresent()) {
                try {
                    class_2291.class_7215 result = class_2291.method_41972((class_7225)class_7225.method_42018((class_2378)class_2378.field_11142), (StringReader)new StringReader(itemIcon.get()));
                    class_1799 item4 = new class_1799((class_1935)result.comp_628().comp_349(), 1);
                    item4.method_7980(result.comp_629());
                    ITEM_CACHE.put(this.info.getId(), item4);
                    return item4;
                }
                catch (CommandSyntaxException result) {
                    // empty catch block
                }
            }
            if ((optional = class_2378.field_11142.method_10220().filter(item -> item.method_40131().method_40237().method_29177().method_12836().equals(this.info.getId())).map(class_1799::new).findFirst()).isPresent() && (item2 = optional.get()).method_7909() != class_1802.field_8162) {
                ITEM_CACHE.put(this.info.getId(), item2);
                return item2;
            }
            return new class_1799((class_1935)class_1802.field_8270);
        }

        private class_2561 getFormattedModName() {
            Object name = this.info.getName();
            int width = this.list.method_25322() - (this.list.method_25331() > 0 ? 30 : 24);
            if (CatalogueModListScreen.this.field_22793.method_1727((String)name) > width) {
                name = CatalogueModListScreen.this.field_22793.method_27523((String)name, width - 10) + "...";
            }
            class_5250 title = class_2561.method_43470((String)name);
            title.method_27692(this.info.getType().getStyle());
            return title;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            CatalogueModListScreen.this.setSelectedModInfo(this.info);
            this.list.method_25313(this);
            return false;
        }

        public ModInfo getInfo() {
            return this.info;
        }
    }

    public record Size2i(int width, int height) {
    }

    private class StringEntry
    extends class_350.class_351<StringEntry> {
        private final String line;

        public StringEntry(String line) {
            this.line = line;
        }

        public void method_25343(class_4587 poseStack, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            class_332.method_25303((class_4587)poseStack, (class_327)CatalogueModListScreen.this.field_22793, (String)this.line, (int)left, (int)top, (int)0xFFFFFF);
        }
    }
}

